;*********************************************
;
; Program: 		Wobman
; Description: 	Namco Pacman clone for Blitz3D
;
; History
;
; 	Date: 		6 Nov,2002
; 	Changes: 	Created
;   Version:	1.11
;   Author:		Colin Gall-McDaid
;
;	Date:		16 Dec, 2016
;	Changes:	Reworked version as a proper Windows game as fullscreen
;               version no longer works
;	Author:		Colin Gall-McDaid
;
;*********************************************

;****************************************************************
;                           constants
;****************************************************************

Const RIGHTARROW=205,LEFTARROW=203,UPARROW=200,DOWNARROW=208
Const MOVEUP=1,MOVEDOWN=2,MOVELEFT=8,MOVERIGHT=4,DONTMOVE=99
Const NORTH=1,SOUTH=2,EAST=4,WEST=8,ENTRANCE=16
Const RED=1,PINK=2,BLUE=3,YELLOW=4
Const GAMESPEED=20
Const OK=256,DEAD=1,NORMALPILL=2,POWERPILL=4,EDIBLE=8,EATEN=16,HOME=32,POINTS=64,SCATTER=128,BEGIN=256
Const GAMEOVER=1,LEVELCOMPLETE=2,START=4,PLAY=8,QUIT=16,INTRO=32,CHOOSEPLAYERS=64
Const PLAYERONE=0,PLAYERTWO=1,COMPUTER=2



;****************************************************************
;                       global variables
;****************************************************************

;main graphics
Global sprites,maze,title, canvas

;pacman info
Global pacimage,wobimage,blank,wobblank,score,pillEaten,ghostsEaten

;ghost images
Global redimage,blueimage,yellowimage,pinkimage,edibleImage1,edibleImage2,fruit
Global eyesRight,eyesLeft,eyesUp,eyesDown
;points images
Global points200,points400,points800,points1600,pointblank
;other images
Global readyImage,p1Image,p2Image,gameOverImage,livesImage,scoresImage,digitImage
Global oneUpImage,twoUpImage,charTitleImage
Global shadow,blinky,speedy,pinky,bashful,inky,pokey,clyde,pillPoints,collywobbles
Global numPlayers,bonuspac,choose

;sounds
Global startWav,chompWav,deathWav,ghostWav,fruitWav,lifeWav,soundFlag,interWav,edibleWav
Global startPlaying, chompPlaying,sirenPlaying,sirenLevel,ediblePlaying,ediblePlayingFlag

;game timers
Global powerTimer#,powerLength,pillFlashTimer#,pointsTimer#,fruitTimer#
Global flashTimer#,scatterTimer#,gameTimer#

;other
Global pointsUp,showFruit,fruitEaten,fruitValue,fruitBlank,flashState,highScore
Global gameState,lastP1Score,scatterFlag,levelSpeed#,cruising,scatterLength,scatterCount
Global currentPlayer,gameMode,gameStart
Global scoreFile,topScore

;auto movement
Global autoDir,autoCurrent,seqNo

;arrays
Dim pill(28,32),pill2(28,32),pillStore(28,32)
Dim choiceList(4)
Dim pillimage(2),fruitImage(7)
Dim siren(5)
Dim autoSequence(50)
Dim flashMaze(2)

;****************************************************************
;                             types
;****************************************************************

;create player type
Type Player
	Field image
	Field blank
	Field x#,y#
	Field frame
	Field animDir
	Field dir
	Field speed#
	Field pillcheck
	Field validDirs
	Field status
	Field timer#
	Field score%
	Field lives
	Field level
	Field mazeImage
	Field pillCount
End Type

;create ghost type
Type Ghost
	Field id
	Field char
	Field nick
	Field image
	Field normal
	Field blank
	Field x#,y#
	Field frame
	Field dir
	Field speed#
	Field validDirs
	Field status
	Field xTarget
	Field yTarget
	Field timer#
	Field running
	Field scatter
End Type

;create junction type
Type Junction
	Field x#,y#
	Field dirs
End Type

;create power pill type
Type Power
	Field image
	Field state
	Field x,y
	Field status
	Field player
End Type

;create points type
Type Points
	Field image
	Field blank
	Field x,y
End Type


; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; Event constants...
; -----------------------------------------------------------------------------

Const EVENT_None		= $0		; No event (eg. a WaitEvent timeout)
Const EVENT_KeyDown		= $101		; Key pressed
Const EVENT_KeyUp		= $102		; Key released
Const EVENT_ASCII		= $103		; ASCII key pressed
Const EVENT_MouseDown	= $201		; Mouse button pressed
Const EVENT_MouseUp		= $202		; Mouse button released
Const EVENT_MouseMove	= $203		; Mouse moved
Const EVENT_Gadget		= $401		; Gadget clicked
Const EVENT_Move		= $801		; Window moved
Const EVENT_Size		= $802		; Window resized
Const EVENT_Close		= $803		; Window closed
Const EVENT_Front		= $804		; Window brought to front
Const EVENT_Menu		= $1001		; Menu item selected
Const EVENT_LostFocus	= $2001		; App lost focus
Const EVENT_GotFocus	= $2002		; App got focus
Const EVENT_Timer		= $4001		; Timer event occurred

; -----------------------------------------------------------------------------
; Create a window...
; -----------------------------------------------------------------------------

; FLAGS...

; 1  : window has titlebar 
; 2  : window is resizable 
; 4  : window has a menu 
; 8  : window has a status bar 
; 16 : window is a 'tool' window - smaller title bar etc. 
; 32 : window uses size given for *client* area (inner area)...

window = CreateWindow ("Game Window (use cursors)...", 0, 0, 640, 480)

; -----------------------------------------------------------------------------
; Create a menu...
; -----------------------------------------------------------------------------

; Note that the & sign in these examples underlines the next letter, and a
; blank menu name creates a 'bar'...

mainmenu = CreateMenu ("&Game", 0, WindowMenu (window))
CreateMenu "&About", 1, mainmenu
CreateMenu "", 2, mainmenu
CreateMenu "E&xit", 3, mainmenu

UpdateWindowMenu window ; This MUST be called after creating your menu!

; -----------------------------------------------------------------------------
; Create a drawing area and 'pin' all edges to parent window...
; -----------------------------------------------------------------------------

canvas = CreateCanvas (0, 0, ClientWidth (window), ClientHeight (window), window)
SetGadgetLayout canvas, 1, 1, 1, 1 ; Use zero to leave an edge 'unpinned'...

;setup game	
LoadGraphics()
LoadSounds()
Setup()

	
Cls

;fileout = WriteFile("hiscore.dat")
;WriteInt(fileout,0)
;CloseFile(fileout)

filein = ReadFile("hiscore.dat")
highScore = ReadInt(filein)
CloseFile(filein)

;create players
introPlayer.Player=CreatePlayer.Player()
player1.Player=CreatePlayer.Player()
player2.Player=CreatePlayer.Player()

;create ghosts
CreateGhosts()

player.Player=First Player

;SetBuffer BackBuffer()


; -----------------------------------------------------------------------------
; All future drawing goes into the drawing area...
; -----------------------------------------------------------------------------

SetBuffer CanvasBuffer (canvas)

; -----------------------------------------------------------------------------
; Frame timing stuff...
; -----------------------------------------------------------------------------

fps = CreateTimer (60)

; -----------------------------------------------------------------------------
; Main loop...
; -----------------------------------------------------------------------------

maze=LoadImage("bitmaps\maze.bmp")

Repeat

	;****************************************************************
	;						main program
	;****************************************************************	

	Select gameState
	
	;play intro screens
	Case QUIT
		Exit
		
	Case CHOOSEPLAYERS
		Color 8,4,6
		Rect 208,50,226,268,True
		
		DrawImage choose,225,178
		DrawImage numPlayers,270,210
		DrawImage bonuspac,217,242
		DrawImage collywobbles,218,300
		FlipCanvas canvas 
		
		While Not (KeyDown(2) Or KeyDown(3) Or KeyDown(1))
			Events()
		Wend
	
		If KeyDown(2)
			gameMode=PLAYERONE
			gameState=START
		ElseIf KeyDown(3)
			gameMode=PLAYERTWO

			gameState=START
		Else
			gameState=QUIT
		EndIf
		
		soundFlag=True
		currentPlayer=PLAYERONE
		
	;game over
	Case GAMEOVER
		DrawImage gameOverImage,282,204
		FlipCanvas canvas

		Wait(3)

		
		If Not (gameState And INTRO)
			If (highScore > topScore)
				topScore = highScore
				; Open/create score file to Write 
				scoreFile = OpenFile("hiscore.dat") 
				
				; Write the information to the file 
				SeekFile(scoreFile,0)
				WriteInt(scoreFile,topScore) 

				; Close the file 
				CloseFile(scoreFile) 
			EndIf
		EndIf
		

		gameState=INTRO
		
		For ppill.Power=Each Power
			Delete ppill
		Next
		
		If gameState=INTRO ResetGhosts()
		
	;start game or end of level
	Case LEVELCOMPLETE, START, (START Or INTRO)
		player=First Player
		
		If Not (gameState And INTRO)
			player=After player
			
			If currentPlayer=PLAYERTWO
				player=After player
			EndIf
		EndIf
		
		;flash maze if level complete
		If (gameState And LEVELCOMPLETE)
			Wait(1)
			
			fmState=0
			For flashCnt=1 To 8
				DrawImage flashMaze(fmState),209,67
				DrawImage player\image,player\x,player\y,0
					
				fmState=Not fmState
				
				FlipCanvas canvas
				Wait(.3)
			Next

			;play intermission at even levels
			odd=player\level Mod 2
			If Not odd
				PlayIntermission()
			EndIf
															
			player\level=player\level+1
			
			Select player\level
			
			Case 1
				levelSpeed#=levelSpeed# + 0.03
			Case 2
				levelSpeed#=levelSpeed# + 0.03
				powerLength=6500
				scatterLength=7000
			Case 3
				levelSpeed#=levelSpeed# + 0.03
				powerLength=6000
				scatterLength=6000
			Case 4
				powerLength=5000
				levelSpeed#=levelSpeed# + 0.03
				scatterLength=5000
			Case 5
				powerLength=3000
			Case 6,10
				powerLength=7000
			Case 7,8,11
				powerLength=3000
			Case 9,12,13,18
				powerLength=1000
			Case 14
				powerLength=4000
			Case 15,16
				powerLength=2000
			Default
				powerLength=0
			
			End Select

		EndIf
			
		;prepare to die!
		;draw and store player mazes
		;DrawImage maze,209,67
		 
		Color 255,255,255
		Rect 207,36,228,302,False
		DrawImage scoresImage,282,42
		DrawImage maze,209,67
		;FlipCanvas canvas
		;Wait(5);

		pp.Player=First Player
		If (gameState And INTRO)
			pp\mazeImage=CopyImage(maze)
			pp\pillCount=244

			For y=0 To 31
				For x=0 To 27
					pill(x,y) = pillStore(x,y)
			   	Next
			Next

			CreatePowerPills()
		ElseIf gameState And START
			For ppill.Power=Each Power
				Delete ppill
			Next		

			pp.Player=First Player
			pp=After pp
			pp\pillCount=244
			pp\mazeImage=CopyImage(maze)
			pp=After pp
			pp\pillCount=244
			pp\mazeImage=CopyImage(maze)

			For y=0 To 31
				For x=0 To 27
					pill(x,y) = pillStore(x,y)
					pill2(x,y) = pillStore(x,y)
			   	Next
			Next
			
			CreatePowerPills()
		ElseIf (gameState And LEVELCOMPLETE)
			;reset power pills
			ResetPills()
			
			;reset maze and pill stores
			pp=After pp
			If currentPlayer=PLAYERONE
				pp\pillCount=244
				pp\mazeImage=CopyImage(maze)

				For y=0 To 31
					For x=0 To 27
						pill(x,y) = pillStore(x,y)
				   	Next
				Next
			ElseIf currentPlayer=PLAYERTWO
				pp=After pp
				pp\pillCount=244
				pp\mazeImage=CopyImage(maze)

				For y=0 To 31
					For x=0 To 27
						pill2(x,y) = pillStore(x,y)
				   	Next
				Next
			EndIf
			
		EndIf
		
		
		If (gameState And INTRO)
			player\lives=1
			player\score=0
			player\level=1
			seqNo=0

			;time allowed for ghost eating	
			powerLength=8000
			scatterLength=8000
			levelSpeed#=1.0
		ElseIf (gamestate And START)
			For pp.Player=Each player
				pp\lives=3
				pp\score=0
				pp\level=1
			Next

			currentPlayer=PLAYERONE
			DisplayScore(player\score)
			currentPlayer=PLAYERTWO
			DisplayScore(player\score)
			currentPlayer=PLAYERONE
						
			;time allowed for ghost eating	
			powerLength=8000
			scatterLength=8000
			levelSpeed#=1.0
	
			;clear current fruit level images
			Color 8,4,6
			Rect 240,318,160,16
			
			gameStart=True
		EndIf
		
		If (gameState And INTRO)
			DrawImage gameOverImage,282,204
			gameState=(PLAY Or INTRO)
		Else
			gameState=PLAY
		EndIf	
		


	;playing!
	Case PLAY, (PLAY Or INTRO)	
		player=First Player
		
		If Not (gameState And INTRO)
			player=After player
			
			If currentPlayer=PLAYERTWO
				player=After player
			EndIf
		EndIf
					
		GameOn(player)

		If Not (gameState And INTRO)
			DrawImage player\mazeImage,209,67

			;re-display scores
			saveCurrent=currentPlayer
			pp.Player=First Player
			pp=After pp
			currentPlayer=PLAYERONE
			DisplayScore(pp\score)

			pp=After pp
			currentPlayer=PLAYERTWO
			DisplayScore(pp\score)

			currentPlayer=saveCurrent
			
			;clear current fruit level/lives images
			Color 8,4,6
			Rect 220,318,180,16

			;display lives
			For cnt=0 To player\lives - 1
				DrawImage livesImage,228+(cnt*15),320
			Next

			;display level in fruit
			For fruitPos=(player\level-1) To 0 Step -1
				SetFruitStatus(fruitPos+1)
				DrawImage fruit,400-(fruitPos*16),318
			Next

			;ready!
			DrawImage readyImage,298,203,0
			
			;display player 1 first time only
			If gameStart
				If soundFlag startPlaying=PlaySound(startWav)
				
				DrawImage p1Image,282,156,0

				;flash 1up during 2 sec pause
				startTimer#=MilliSecs()

				While ((MilliSecs() < startTimer# + 2000) And (Not KeyDown(1)))
					Events()
					DisplayScore(player\score)	
					FlipCanvas canvas
				Wend
		
				DrawImage p1Image,282,156,1
				gameStart=False
			EndIf
		;Else
		;	DrawImage player\mazeImage,209,67
		EndIf

		;nearly ready?
		StoreBackgroundData()
		DrawSprites()
		
		DrawImage fruitBlank,228+((player\lives-1)*15),320		
		Wait(.4)
		
		;keep flashing 1up if playing
		If Not (gameState And INTRO)
			startTimer#=MilliSecs()	

			While ((MilliSecs() < startTimer# + 2000) And (Not KeyDown(1)))
				Events()
				DisplayScore(player\score)
				FlipCanvas canvas
			Wend
		Else
			;DisplayScore(lastP1Score)
			;Flip
			Wait(2)
		EndIf
		
		;clear ready! image
		If Not (gameState And INTRO)
			DrawImage ReadyImage,298,203,1
		EndIf

		;start siren sound
		If soundFlag
			sirenPlaying=PlaySound(siren(sirenLevel))
		EndIf
		
		;set timers and go...go...go
		pillFlashTimer#=MilliSecs()
		timer#=MilliSecs()
		player\timer#=MilliSecs()
		scatterTimer#=MilliSecs()

		For g.Ghost=Each Ghost
			g\timer#=MilliSecs()
		Next

		;********************
		;main level/life loop
		;********************
		gameTimer# = MilliSecs() + GAMESPEED

		While (player\status<>DEAD) And (gameState<>LEVELCOMPLETE) And (Not KeyDown(1))
		
		Events()

		gameDelay# = MilliSecs()
		If (gameDelay# > gameTimer#)
			gameTimer# = MilliSecs() + GAMESPEED
			
			;if playing intro, check for space to start
			If (gameState And INTRO)
				If KeyDown(57)
					gameState=START
					Exit
				EndIf
			EndIf
			
			;scatter/unscatter
			If scatterFlag
				If MilliSecs() > scatterTimer# + scatterLength
					For g.Ghost=Each Ghost
						If g\status And SCATTER
							g\status=g\status Xor SCATTER
						EndIf
					Next
					
					scatterFlag=False
					scatterTimer#=MilliSecs()
				EndIf
			Else
				If MilliSecs() > scatterTimer# + 15000
					If scatterCount < 4
						For g.Ghost=Each Ghost
							If g\status And OK
								g\status=g\status Or SCATTER
							EndIf
						Next
						scatterCount=scatterCount + 1
						scatterFlag=True
						scatterTimer#=MilliSecs()
					EndIf
				EndIf
			EndIf
			
			;play siren
			If soundFlag
				If ((player\pillCount < 17) And (sirenLevel = 3))
					sirenLevel = 4
				ElseIf ((player\pillCount < 33) And (sirenLevel = 2))
					sirenLevel = 3
				ElseIf ((player\pillCount < 65) And (sirenLevel = 1))
					sirenLevel = 2
				ElseIf ((player\pillCount < 128) And (sirenLevel = 0))
					sirenLevel = 1
				ElseIf player\pillCount > 127
					sirenLevel = 0
				EndIf
			EndIf
			
			If (Not ChannelPlaying(sirenPlaying)) And soundFlag
				sirenPlaying=PlaySound(siren(sirenLevel))
			EndIf

			
			;clear sprites
			ClearSprites()
			
			;freeze game while points are displayed
			If Not pointsUp
				;move player
				MovePlayer(player)	
				CheckPill(player)
		
				;move ghosts
				MoveGhosts(player)
			Else
				ShowPoints()
			EndIf
	
			;draw fruit as needed
			If showFruit
				DisplayBonusFruit(player)
			EndIf
	
			;power pill timer
			ProcessPowerPills(player)
	
			;draw sprites
			StoreBackgroundData()
			DrawSprites()

			;draw passage on top of anyone in them
			DrawPassages()
	
			;show score
			If Not (gameState And INTRO)
				If (player\score > 9999) And (Not lifeFlag)
					player\lives=player\lives + 1
					
					;display lives
					livesPos=(player\lives - 2) * 15
					DrawImage livesImage,228+livesPos,320
					lifeFlag=True
					lifePlaying=PlaySound(lifeWav)
				ElseIf (player\score > 99990)
					player\score = 0
				EndIf
				DisplayScore(player\score)
			EndIf
			
			;check for collisions
			CheckCollisions(player)
	
			If player\status=DEAD
				PlayDead(player)
			EndIf	
		
			;flipping buffers
			FlipCanvas canvas
		EndIf
		Wend	


	Case INTRO
		RunIntro()

	End Select
	
	; -------------------------------------------------------------------------
	; The Canvas version of Flip...
	; -------------------------------------------------------------------------
			
	FlipCanvas canvas

Until (KeyHit (1))
	
End

;****************************************************************
;						functions
;****************************************************************

;load graphics
Function LoadGraphics()

	;main graphics
	sprites=LoadImage("bitmaps\sprites.bmp")
	maze=LoadImage("bitmaps\maze.bmp")
	flashMaze(0)=LoadImage("bitmaps\mazeflash1.bmp")
	flashMaze(1)=LoadImage("bitmaps\mazeflash2.bmp")
	
	SetBuffer ImageBuffer(sprites)
	
	;wobman
	pacimage=CreateImage(14,14,15)

	For frameCnt=0 To 14
		GrabImage pacimage,(frameCnt*16+1),1,framecnt
		MaskImage pacimage,8,4,6
	Next

	;big wobman
	wobimage=CreateImage(32,32,3)
	wobblank=CreateImage(32,32)
	
	For frameCnt=0 To 2
		GrabImage wobimage,1+(35*frameCnt),145,frameCnt
	Next
	
	GrabImage wobblank,106,145
	
	;for your eyes only
	eyesLeft=CreateImage(14,7)
	GrabImage eyesLeft,1,35
	MaskImage eyesLeft,8,4,6
	
	eyesDown=CreateImage(14,7)
	GrabImage eyesDown,17,35
	MaskImage eyesDown,8,4,6
	
	eyesRight=CreateImage(14,7)
	GrabImage eyesRight,33,35
	MaskImage eyesRight,8,4,6
	
	eyesUp=CreateImage(14,7)
	GrabImage eyesUp,49,35
	MaskImage eyesUp,8,4,6
	
	;red ghost
	redimage=CreateImage(14,14,2)
	GrabImage redimage,1,17,0
	GrabImage redimage,17,17,1
	MaskImage redimage,8,4,6
	
	blueimage=CreateImage(14,14,2)
	GrabImage blueimage,33,17,0
	GrabImage blueimage,49,17,1
	MaskImage blueimage,8,4,6
	
	yellowimage=CreateImage(14,14,2)
	GrabImage yellowimage,65,17,0
	GrabImage yellowimage,81,17,1
	MaskImage yellowimage,8,4,6
	
	pinkimage=CreateImage(14,14,2)
	GrabImage pinkimage,97,17,0
	GrabImage pinkimage,113,17,1
	MaskImage pinkimage,8,4,6
	
	;edible ghost
	edibleImage1=CreateImage(14,14,2)
	GrabImage edibleImage1,129,17,0
	GrabImage edibleImage1,145,17,1
	MaskImage edibleImage1,8,4,6
	
	edibleImage2=CreateImage(14,14,2)
	GrabImage edibleImage2,161,17,0
	GrabImage edibleImage2,177,17,1
	MaskImage edibleImage2,8,4,6
	
	;blank image
	blank=CreateImage(14,14)
	GrabImage blank,48,64,0
	
	;score images
	points200=CreateImage(16,7)
	points400=CreateImage(16,7)
	points800=CreateImage(16,7)
	points1600=CreateImage(16,7)
	pointblank=CreateImage(16,7)
	GrabImage points200,64,36
	GrabImage points400,81,36
	GrabImage points800,96,36
	GrabImage points1600,112,36
	GrabImage pointblank,108,89
	
	;fruit images
	;0=cherry,1=strawberry,2=orange,3=apple,4=grapes,5=galaxian,6=bell,7=key
	For fruitCnt=0 To 7
		fruitImage(fruitCnt) = CreateImage(16,16)
		GrabImage fruitImage(fruitCnt),(fruitCnt*16),48
		MaskImage fruitImage(fruitCnt),8,4,6
	Next

	fruitBlank=CreateImage(16,16)
	GrabImage fruitBlank,196,18
	;MaskImage fruitBlank,8,4,6
	
	;ready! image
	readyImage=CreateImage(46,7,2)
	GrabImage readyImage,1,67,0
	GrabImage readyImage,130,35,1
	
	;game over
	gameOverImage=CreateImage(79,7)
	GrabImage gameOverImage,140,67
	;MaskImage gameOverImage,8,4,6
	
	;scores image
	scoresImage=CreateImage(79,7)
	GrabImage scoresImage,48,75
	
	;player one image
	p1Image=CreateImage(79,7,2)
	GrabImage p1Image,53,67,0
	GrabImage p1Image,130,35,1
	
	;player two image
	p2Image=CreateImage(79,7,2)
	GrabImage p2Image,64,108,0
	GrabImage p2Image,130,35,1
	
	;lives image
	livesImage=CreateImage(10,11)
	GrabImage livesImage,130,50
	
	;number digits
	digitImage=CreateImage(8,7,10)
	For digit=0 To 9
		GrabImage digitImage,digit*8,83,digit
	Next
	
	;1 up/2 up!
	oneUpImage=CreateImage(23,7)		
	twoUpImage=CreateImage(23,7)		
	GrabImage oneUpImage,0,75
	GrabImage twoUpImage,152,75
	
	;intro graphics
	charTitleImage=CreateImage(159,7)
	GrabImage charTitleImage,81,83
	
	;shadow/blinky
	shadow=CreateImage(53,7)
	blinky=CreateImage(61,7)
	GrabImage shadow,1,91
	GrabImage blinky,55,91
	
	;speedy/pinky
	speedy=CreateImage(53,7)
	pinky=CreateImage(53,7)
	GrabImage speedy,118,91
	GrabImage pinky,172,91
	
	;bashful/inky
	bashful=CreateImage(61,7)
	inky=CreateImage(45,7)
	GrabImage bashful,1,99
	GrabImage inky,64,99
	
	;pokey/clyde
	pokey=CreateImage(45,7)
	clyde=CreateImage(53,7)
	GrabImage pokey,110,99
	GrabImage clyde,156,99
	
	;title image of pills and points
	pillPoints=CreateImage(57,25)
	GrabImage pillPoints,2,107
	
	;collywobbles software
	collywobbles=CreateImage(208,7)
	GrabImage collywobbles,1,135
	
	;1 or 2 players
	numPlayers=CreateImage(111,7)
	GrabImage numPlayers,64,116
	
	;bonus pacman at 10000 pts
	bonuspac=CreateImage(209,7)
	GrabImage bonuspac,1,179
	
	;choose 1 or 2 players
	choose=CreateImage(191,7)
	GrabImage choose,1,187
	
	;power pill graphics
	pillimage(0)=CreateImage(8,8)
	pillimage(1)=CreateImage(8,8)
	pillimage(2)=CreateImage(8,8)
	
	SetBuffer ImageBuffer(maze)
	GrabImage pillimage(0),8,24
	GrabImage pillimage(1),108,89
	GrabImage pillimage(2),8,16
	
	
End Function


;load sounds
Function LoadSounds()

	startWav=LoadSound("sounds\start.wav")
	
	siren(0)=LoadSound("sounds\siren1.wav")
	siren(1)=LoadSound("sounds\siren2.wav")
	siren(2)=LoadSound("sounds\siren3.wav")
	siren(3)=LoadSound("sounds\siren4.wav")
	siren(4)=LoadSound("sounds\siren5.wav")
	
	chompWav=LoadSound("sounds\chomp.wav")
	deathWav=LoadSound("sounds\death.wav")
	fruitWav=LoadSound("sounds\fruit.wav")
	ghostWav=LoadSound("sounds\ghost.wav")
	lifeWav=LoadSound("sounds\life.wav")
	interWav=LoadSound("sounds\interm.wav")
	edibleWav=LoadSound("sounds\blue.wav")
	
End Function


;create player
Function CreatePlayer.Player()

	p.Player=New Player
	
	p\image=pacimage
	p\blank=blank
	p\x=316
	p\y=248
	p\frame=0
	p\animDir=-1
	p\dir=MOVELEFT
	p\speed#=0
	p\validDirs=EAST Or WEST
	p\status=BEGIN
	p\level=0
	p\lives=3
	
	Return p
	
End Function


;clear all sprites
Function ClearSprites()

	For g.Ghost=Each Ghost
		DrawImage g\blank,g\x,g\y
	Next

	p.Player=First Player
	
	If (Not gameState And INTRO)
		p=After p
		
		If currentPlayer=PLAYERTWO
			p=After p
		EndIf
	EndIf
	
	DrawImage p\blank,p\x,p\y

End Function


;store sprite background data
Function StoreBackgroundData()

	For g.Ghost=Each Ghost
		GrabImage g\blank,g\x,g\y
	Next

	p.Player=First Player
	
	If (Not gameState And INTRO)
		p=After p

		If currentPlayer=PLAYERTWO
			p=After p
		EndIf
	EndIf

	GrabImage p\blank,p\x,p\y

End Function


Function DrawSprites()

	;draw ghost sprites
	For g.Ghost=Each Ghost
		If Not (g\status And EATEN)
			DrawImage g\image,g\x,g\y,g\frame
		EndIf
		
		;don't display eyes if edible or on intro screen
		If Not pointsUp Or (g\status And EDIBLE)
			If ((Not gameState=INTRO) Or (Not g\status And EATEN))
				Select g\dir
		
				Case MOVERIGHT
					DrawImage eyesRight,g\x,g\y+2

				Case MOVELEFT
					DrawImage eyesLeft,g\x,g\y+2

				Case MOVEUP	
					DrawImage eyesUp,g\x,g\y+2

				Case MOVEDOWN
					DrawImage eyesDown,g\x,g\y+2
			
				End Select
			EndIf
		EndIf
	Next

	;draw player sprite if not displaying ghost eaten points
	If Not pointsUp	
		p.Player=First Player
		
		If (Not gameState And INTRO)
			p=After p

			If currentPlayer=PLAYERTWO
				p=After p
			EndIf
		EndIf
		
		DrawImage p\image,p\x,p\y,p\frame
	EndIf
	
End Function



;create ghosts
Function CreateGhosts()
	
	For ghostCnt=1 To 4
		g.Ghost=New Ghost
		g\blank=CreateImage(14,14)
		;g\status=HOME
		g\status=g\status And SCATTER
		g\running=False
	
		Select ghostCnt

		Case RED
			g\id=RED
			g\char=shadow
			g\nick=blinky
			g\normal=redimage
			g\image=redimage
			g\x=314
			g\y=152
			g\frame=0
			g\dir=MOVELEFT
		
		Case BLUE
			g\id=BLUE
			g\char=bashful
			g\nick=inky
			g\normal=blueimage
			g\image=blueimage
			g\x=298
			g\y=176
			g\frame=0
			g\dir=MOVEUP
	
		Case YELLOW
			g\id=YELLOW
			g\char=pokey
			g\nick=clyde
			g\normal=yellowimage
			g\image=yellowimage
			g\x=330
			g\y=176
			g\frame=0		
			g\dir=MOVEUP
	
		Case PINK
			g\id=PINK
			g\char=speedy
			g\nick=pinky
			g\normal=pinkimage
			g\image=pinkimage
			g\x=314
			g\y=176
			g\frame=0
			g\dir=MOVEDOWN
		
		End Select	
	
		GrabImage g\blank,g\x,g\y
		
	Next

End Function

Function ResetGhosts()

	index=1
	For g.Ghost=Each Ghost
		g\status=(OK Or SCATTER)
		g\running=False
		
		Select index

		Case RED
			g\image=redimage
			g\x=314
			g\y=152
			g\frame=0
			g\dir=MOVERIGHT
			g\speed#=levelSpeed#
		
		Case BLUE
			g\image=blueimage
			g\x=298
			g\y=176
			g\frame=0
			g\dir=MOVEUP
			g\speed#=levelSpeed#
	
		Case YELLOW
			g\image=yellowimage
			g\x=330
			g\y=176
			g\frame=0		
			g\dir=MOVEUP
			g\speed#=levelSpeed#
	
		Case PINK
			g\image=pinkimage
			g\x=314
			g\y=176
			g\frame=0
			g\dir=MOVEDOWN
			g\speed#=levelSpeed#
		
		End Select	
		
		index=index+1
	Next

End Function


Function Setup()

	;Store pill Data
	For y=0 To 31
		For x=0 To 27
			Read pilldata
			pillStore(x,y) = pilldata
	   	Next
	Next

	;store junction data
	For junc=0 To 71
		Read x,y,dir
		
		j.Junction=New Junction
		j\x=x
		j\y=y
		j\dirs=dir
	Next
	
	;read auto moves sequence
	For moveCnt=0 To 39
		Read move
		
		autoSequence(moveCnt)=move
	Next

	;start high score
	;highScore=0
	
	;start with intro sequence
	gameState=INTRO

End Function



Function GameOn(p.Player)

	ghostsEaten=0
	showFruit=False
	fruitEaten=False
	fruitTimer#=0

	flashTimer#=MilliSecs()

	;reset player parameters	
	p\x=316
	p\y=248
	p\frame=0
	p\animDir=-1
	p\dir=MOVELEFT
	p\validDirs=EAST Or WEST
	p\status=OK
	p\speed#=levelSpeed#

	;reset game parameters
	ghostsEaten=0
	showFruit=False
	fruitEaten=False
	fruitTimer#=0

	;create ghosts
	ResetGhosts()
	scatterFlag=True
	scatterCount=1
	
	cruising=False

End Function


;move pacman
Function MovePlayer(p.Player)

	;check junctions
	p\validDirs=ValidDirections(p)
	
	p\pillcheck=0
	
	If (gameState And INTRO)
		If PlayerAtJunction(p)
			autoDir=autoSequence(seqNo)
			seqNo=seqNo+1
		EndIf
	Else 
		autoDir=0
	EndIf
	
	;FlushKeys
	
	;turn right
	If KeyDown(RIGHTARROW) Or autoDir=MOVERIGHT
		If (p\validDirs And EAST)
			If p\dir<>MOVERIGHT
				p\frame=1
				p\dir=MOVERIGHT
			EndIf
		EndIf
	;turn left
	ElseIf KeyDown(LEFTARROW) Or autoDir=MOVELEFT
		If (p\validDirs And WEST)
			If p\dir<>MOVELEFT
				p\frame=5
				p\dir=MOVELEFT
			EndIf
		EndIf
	;turn up
	ElseIf KeyDown(UPARROW) Or autoDir=MOVEUP
		If (p\validDirs And NORTH)
			If p\dir<>MOVEUP
				p\frame=7
				p\dir=MOVEUP
			EndIf
		EndIf
	;turn down
	ElseIf KeyDown(DOWNARROW) Or autoDir=MOVEDOWN
		If (p\validDirs And SOUTH)
			If p\dir<>MOVEDOWN
				p\frame=3
				p\dir=MOVEDOWN
			EndIf
		EndIf
	EndIf
		

	;move right
	If p\dir=MOVERIGHT
		
		If (p\validDirs And EAST)			
			p\x=p\x+p\speed#
			p\frame=p\frame+p\animDir
			
			If p\x > 438 p\x = 192
			
			If p\frame=2 Or p\frame=0
				p\animDir=-p\animDir
			EndIf
		EndIf
	;move left
	ElseIf p\dir=MOVELEFT
		If (p\validDirs And WEST)
			p\x=p\x-p\speed#
			p\frame=p\frame+p\animDir
			
			If p\x < 192 p\x = 438

			If p\frame=4
				p\frame=0
			ElseIf p\frame=-1
				p\frame=5
				p\animDir=-p\animDir
			ElseIf p\frame=6
				p\animDir=-p\animDir
			EndIf
		EndIf
	;move up
	ElseIf p\dir=MOVEUP
		If (p\validDirs And NORTH)
			p\y=p\y-p\speed#
			p\frame=p\frame+p\animDir
		
			If p\frame=6
				p\frame=0
			ElseIf p\frame=-1
				p\frame=7
				p\animDir=-p\animDir
			ElseIf p\frame=8
				p\animDir=-p\animDir
			EndIf
		EndIf
	;move down
	ElseIf p\dir=MOVEDOWN
		If (p\validDirs And SOUTH)
			p\y=p\y+p\speed#
			p\frame=p\frame+p\animDir
		
			If p\frame=2
				p\frame=0
			ElseIf p\frame=-1
				p\frame=3
				p\animDir=-p\animDir
			ElseIf p\frame=4
				p\animDir=-p\animDir
			EndIf
		EndIf
	EndIf
	
	;EndIf
		
End Function


Function MoveGhosts(p.Player)

	For ghost.Ghost=Each Ghost
		
		;only move ghost at correct speed
		;If MilliSecs() > ghost\timer# + ghost\speed#
			;ghost\timer# = MilliSecs()
			
			ghost\frame = Not ghost\frame
		
			;turn blinky into "cruise elroy" - ie speed him up
			If ghost\id=RED
			If (ghost\status And OK)
			If Not cruising
				Select p\level
			
				Case 1
					If p\pillCount<20
						ghost\speed#=ghost\speed# + 0.1
						cruising=True
					EndIf
				
				Case 2
					If p\pillCount<30
						ghost\speed#=ghost\speed# + 0.1
						cruising=True
					EndIf
			
				Case 3,4,5
					If p\pillCount<40
						ghost\speed#=ghost\speed# + 0.1
						cruising=True
					EndIf
			
				Case 6,7,8
					If p\pillCount<50
						ghost\speed#=ghost\speed# + 0.1
						cruising=True
					EndIf
			
				Case 9,10
					If p\pillCount<60
						ghost\speed#=ghost\speed# + 0.1
						cruising=True
					EndIf
					
				End Select
				
				EndIf
				EndIf
			EndIf
			
			
			;set ghost target parameters
			Select ghost\status

			;set target for healthy ghost
			Case OK,(OK Or SCATTER)
				
				;give me a break
				If (ghost\status And SCATTER)
					
					Select ghost\id
					Case RED
						ghost\xTarget=414
						ghost\yTarget=72
					Case PINK
						ghost\xTarget=214
						ghost\yTarget=72
					Case YELLOW
						ghost\xTarget=214
						ghost\yTarget=296
					Case BLUE
						ghost\xTarget=414
						ghost\yTarget=296
					End Select
				
					If Not ghost\scatter
						;turn in opposite direction
						Select ghost\dir
					
						Case NORTH
							ghost\dir=SOUTH
				
						Case SOUTH
							ghost\dir=NORTH
				
						Case EAST	
							ghost\dir=WEST
					
						Case WEST	
							ghost\dir=EAST
					
						End Select
					
						ghost\scatter=True
					EndIf
				Else
					If ghost\scatter
						;turn in opposite direction
						Select ghost\dir
					
						Case NORTH
							ghost\dir=SOUTH
				
						Case SOUTH
							ghost\dir=NORTH
				
						Case EAST	
							ghost\dir=WEST
					
						Case WEST	
							ghost\dir=EAST
					
						End Select
					
						ghost\scatter=False
					EndIf
					
					ghost\xTarget=p\x
					ghost\yTarget=p\y
				EndIf
							
			;run for your lives!
			Case EDIBLE
				If p\x < 314
					ghost\xTarget=414
				Else
					ghost\xTarget=214
				EndIf
				
				If p\y < 184
					ghost\yTarget=296
				Else
					ghost\yTarget=72
				EndIf
				
				If ghost\running=False
					;run in opposite direction
					Select ghost\dir
				
					Case NORTH
						ghost\dir=SOUTH
				
					Case SOUTH
						ghost\dir=NORTH
				
					Case EAST
						ghost\dir=WEST
					
					Case WEST
						ghost\dir=EAST
				
					End Select
					
					ghost\running=True
				EndIf
				
				
				
			;set target for eaten ghost
			Case EATEN
				ghost\xTarget=314
				If ghost\y=152 And ghost\x=314
					ghost\yTarget=176
				Else
					ghost\yTarget=152
				EndIf

				If ghost\x=314 And ghost\y=176
					ghost\status=OK
					ghost\image=ghost\normal
					ghost\speed#=levelSpeed#
					ghost\xTarget=314
					ghost\yTarget=152
				EndIf
					
			End Select


			;choose dir if at junction		
			If atJunction(ghost)
				
				index=0
				yCheck = ghost\yTarget - ghost\y
				xCheck = ghost\xTarget - ghost\x

				;try to pick an intelligent direction (use paranormal powers!!)
				oldDir=ghost\dir
				options=ghost\validDirs
				ghost\dir=DONTMOVE
				
				Select oldDir
				
				;choose dir when moving left or right
				Case MOVERIGHT,MOVELEFT
					If (options And oldDir)
						If Abs(xCheck) > Abs(yCheck)
							ghost\dir=oldDir
						ElseIf (options And NORTH)
							If (ghost\yTarget < ghost\y)
								ghost\dir=MOVEUP
							Else
								ghost\dir=oldDir
							EndIf
						ElseIf (options And SOUTH)
							If (ghost\yTarget > ghost\y)
								ghost\dir=MOVEDOWN
							Else
								ghost\dir=oldDir
							EndIf
						ElseIf (ghost\status And EATEN)
							If (options And ENTRANCE)
								ghost\dir=MOVEDOWN
							EndIf
						Else
							ghost\dir=oldDir
						EndIf
					ElseIf (options And MOVEUP)
						If (options And MOVEDOWN)
							If yCheck < 0
								ghost\dir=MOVEUP
							Else
								ghost\dir=MOVEDOWN
							EndIf
						ElseIf (options And oldDir)
							ghost\dir=oldDir
						ElseIf (options And SOUTH)
							ghost\dir=MOVEDOWN
						Else
							ghost\dir=MOVEUP
						EndIf
					ElseIf (options And oldDir)
						ghost\dir=oldDir
					ElseIf (options And SOUTH)
						ghost\dir=MOVEDOWN
					Else
						ghost\dir=MOVEUP
					EndIf
				
				;choose dir when moving north or south
				Case MOVEUP,MOVEDOWN
					If (options And oldDir)
						If (Abs(yCheck) > Abs(xCheck))
							ghost\dir=oldDir
						ElseIf (options And EAST)
							If (ghost\xTarget > ghost\x)
								ghost\dir=MOVERIGHT
							Else
								ghost\dir=oldDir
							EndIf
						ElseIf (options And WEST)
							If (ghost\xTarget < ghost\x)
								ghost\dir=MOVELEFT
							Else
								ghost\dir=oldDir
							EndIf
						Else
							ghost\dir=oldDir
						EndIf
					ElseIf (options And MOVERIGHT)
						If (options And MOVELEFT)
							If xCheck < 0
								ghost\dir=MOVELEFT
							Else
								ghost\dir=MOVERIGHT
							EndIf
						ElseIf (options And oldDir)
							ghost\dir=oldDir
						ElseIf (options And EAST)
							ghost\dir=MOVERIGHT
						Else
							ghost\dir=MOVELEFT
						EndIf
					ElseIf (options And WEST)
						ghost\dir=MOVELEFT
					ElseIf (options And oldDir)
						ghost\dir=oldDir
					ElseIf (options And EAST)
						ghost\dir=MOVERIGHT
					ElseIf oldDir=MOVEUP
						ghost\dir=MOVEDOWN
					Else
						ghost\dir=MOVEUP
					EndIf
						
				End Select					
					
				;no move found - error!
				If ghost\dir=DONTMOVE Stop
			EndIf
		
				
			;move in selected dir
			Select ghost\dir
	
			Case MOVERIGHT
				ghost\x#=ghost\x#+ghost\speed#
				If ghost\x > 438 ghost\x=192
			
			Case MOVELEFT
				ghost\x#=ghost\x#-ghost\speed#
				If ghost\x < 192 ghost\x=438
				
			Case MOVEUP
				ghost\y#=ghost\y#-ghost\speed#
				
			Case MOVEDOWN
				ghost\y#=ghost\y#+ghost\speed#
		
			End Select
		
			
		;EndIf
	
	Next
	
End Function


Function CheckPill(p.Player)
	
	xPos=Int(p\x#)
	yPos=Int(p\y#)
	
	If xPos > 212 And xPos < 416

		;map player coords to pill data
		Select p\dir
	
		Case MOVERIGHT
			xLoc=xPos / 8 - 25
			yLoc=yPos / 8 - 9
			
			xPill=xPos + 9
			yPill=yPos + 3
			
		Case MOVELEFT
			xLoc=(xPos + 2) / 8 - 26
			yLoc=yPos / 8 - 9
			
			xPill=xPos - 3
			yPill=yPos + 3
		
		Case MOVEUP
			xLoc=xPos / 8 - 25
			yLoc=yPos / 8 - 9
			
			xPill=p\x + 3
			yPill=p\y - 3
		
		Case MOVEDOWN
			xLoc=xPos / 8 - 25
			yLoc=(yPos - 2) / 8 - 8
			
			xPill=xPos + 3
			yPill=yPos + 9
			
		End Select


		;check if a pill has been eaten
		If currentPlayer=PLAYERONE
			pillType=pill(xLoc,yLoc)
		ElseIf currentPlayer=PLAYERTWO
			pillType=pill2(xLoc,yLoc)
		Else
			pillType=pill(xLoc,yLoc)
		EndIf
		
		
		Select pillType

		;normal pill
		Case 2
			;10 points
			p\score=p\score+10
			
			;Blitz Bug? chompPlaying is remains 1 when started 
			;the first time! Have to stop it manually. Ok from
			;then on
			If (p\score < 20) StopChannel(chompPlaying)
			
			If (Not ChannelPlaying(chompPlaying)) And soundFlag
				chompPlaying=PlaySound(chompWav)
			EndIf

			p\pillCount=p\pillCount-1
			pillEaten=True
			DrawImage pillimage(1),xPill,yPill
			

		;power pill
		Case 4
			;50 points! ooohhhh!
			p\score=p\score+50
			If (Not ChannelPlaying(chompPlaying)) And soundFlag
				chompPlaying=PlaySound(chompWav)
			EndIf
			p\pillCount=p\pillCount-1

			;elevate player status
			p\status=POWERPILL
			ghostsEaten=0

			;turn ghosts edible
			For g.Ghost=Each Ghost
				If (g\status And OK) Or (g\status And EDIBLE) Or (g\status And SCATTER)
					g\status=EDIBLE
					g\image=edibleImage1
					g\speed#=levelSpeed# - 0.2
				EndIf
			Next
			
			powerTimer#=MilliSecs() + powerLength

			;disable eaten power pill
			If xLoc=1 And yLoc=2
				index=1
			ElseIf xLoc=26 And yLoc=2
				index=2
			ElseIf xLoc=1 And yLoc=22
				index=3
			ElseIf xLoc=26 And yLoc=22
				index=4
			EndIf
			
			If currentPlayer=PLAYERTWO
				index=index+4
			EndIf
			
			pillNo=1
			For ppill.Power=Each Power
				If pillNo=index
					DrawImage pillimage(1),ppill\x,ppill\y
					ppill\status=EATEN
				EndIf
				pillNo=pillNo+1
			Next
			
		End Select
		
		;clear pill location
		If currentPlayer=PLAYERONE
			pill(xLoc,yLoc)=0
		ElseIf currentPlayer=PLAYERTWO
			pill2(xLoc,yLoc)=0
		Else
			pill(xLoc,yLoc)=0
		EndIf
		
		;pop bonus fruit up at correct points in game
		If p\pillCount=174 Or p\pillCount=74
			showFruit=True
			fruitTimer#=0
		EndIf
		
		;all pills eaten?
		If p\pillCount=0
			gameState=LEVELCOMPLETE
		EndIf

	EndIf
		
End Function


Function ValidDirections(p.Player)
	
	For junction.Junction=Each Junction
		If ((p\x# > junction\x - p\speed#) And (p\x# < junction\x + p\speed#))
			If ((p\y# > junction\y - p\speed#) And (p\y# < junction\y + p\speed#))
				
				p\validDirs=junction\dirs
				
				p\x#=junction\x
				p\y#=junction\y
		
				Return p\validDirs
			EndIf
		EndIf
	Next
	
	If p\dir=MOVERIGHT Or p\dir=MOVELEFT
		Return EAST Or WEST
	ElseIf p\dir=MOVEUP Or p\dir=MOVEDOWN
		Return NORTH Or SOUTH
	EndIf

End Function


Function AtJunction(ghost.Ghost)
	
	For junction.Junction=Each Junction
		If ((ghost\x# > junction\x - ghost\speed#) And (ghost\x# < junction\x + ghost\speed#))
			If ((ghost\y# > junction\y - ghost\speed#) And (ghost\y# < junction\y + ghost\speed#))
				ghost\validDirs=junction\dirs
				
				ghost\x#=junction\x
				ghost\y#=junction\y
		
				Return True
			EndIf
		EndIf
	Next
	
	Return False
	
End Function


Function PlayerAtJunction(p.Player)
	
	For junction.Junction=Each Junction
		If ((p\x# > junction\x - p\speed#) And (p\x# < junction\x + p\speed#))
			If ((p\y# > junction\y - p\speed#) And (p\y# < junction\y + p\speed#))
				p\validDirs=junction\dirs
				
				p\x#=junction\x
				p\y#=junction\y
		
				Return True
			EndIf
		EndIf
	Next
	
	Return False
	
End Function


;draw passage doorways (to hide what's in them)
Function DrawPassages()

	Color 8,4,6
	Rect 57,176,150,215,True
	Rect 435,176,150,215,True

End Function


;check collisions
Function CheckCollisions(p.Player)

	;player/ghost colllision detection
	For g.Ghost=Each Ghost
		If ImagesCollide(g\image,g\x,g\y,0,p\image,p\x,p\y,0)
			
			Select p\status
			
			Case OK
				If (g\status And OK)
					p\status=DEAD
				EndIf
				
			Case POWERPILL
				If (g\status And EDIBLE)
					If soundFlag ghostPlaying=PlaySound(ghostWav)
					
					g\status=EATEN
					g\speed#=3.0
					
					pointsTimer#=MilliSecs()
					ghostsEaten=ghostsEaten+1
					
					;create points image
					pts.Points=New Points
					
					;choose points graphic
					Select ghostsEaten
					
					Case 1
						pts\image=points200
						p\score=p\score+200

					Case 2
						pts\image=points400
						p\score=p\score+400
					Case 3
						pts\image=points800
						p\score=p\score+800

					Case 4
						pts\image=points1600
						p\score=p\score+1600

					End Select
					
					pts\x=g\x
					pts\y=g\y+2
					pointsUp=True
				EndIf
				
				If (g\status And OK)
					p\status=DEAD
				EndIf
			
			End Select
			
		EndIf
		
		If pointsUp Exit
	Next

	;player fruit collision detection
	If showFruit
		For fruitCnt=0 To 7
			If ImagesCollide(fruitImage(fruitCnt),314,199,0,p\image,p\x,p\y,0)
				fruitEaten=True
			EndIf
		Next
	EndIf
	
End Function


;create power pills
Function CreatePowerPills()

	If (currentPlayer=PLAYERONE Or gameState=START)
		For pillNo=0 To 3
			ppill.Power=New Power
			ppill\image=pillimage(0)
			ppill\state=1
			ppill\status=OK
		
			Select pillNo
		
			Case 0
				ppill\x=217
				ppill\y=91	
				ppill\player=PLAYERONE
			
			Case 1
				ppill\x=417
				ppill\y=91
				ppill\player=PLAYERONE
			
			Case 2
				ppill\x=217
				ppill\y=251
				ppill\player=PLAYERONE
			
			Case 3
				ppill\x=417
				ppill\y=251
				ppill\player=PLAYERONE
				
			End Select
		Next
	EndIf
	
	If (currentPlayer=PLAYERTWO Or gameState=START)
		For pillNo=4 To 7
			ppill.Power=New Power
			ppill\image=pillimage(0)
			ppill\state=1
			ppill\status=OK
		
			Select pillNo		
	
			Case 4
				ppill\x=217
				ppill\y=91
				ppill\player=PLAYERTWO
			
			Case 5
				ppill\x=417
				ppill\y=91
				ppill\player=PLAYERTWO
			
			Case 6
				ppill\x=217
				ppill\y=251
				ppill\player=PLAYERTWO
			
			Case 7
				ppill\x=417
				ppill\y=251
				ppill\player=PLAYERTWO
		
			End Select
		Next
	EndIf
	
End Function


Function ResetPills()

	If currentPlayer=PLAYERONE
		ppill.Power=First Power
		For pillCnt=1 To 4
			ppill\status=OK
			ppill=After ppill
		Next
	ElseIf currentPlayer=PLAYERTWO
		ppill.Power=Last Power
		For pillCnt=1 To 4
			ppill\status=OK
			ppill=Before ppill
		Next
	EndIf

End Function


;processed peas - I mean process power pills!
Function ProcessPowerPills(p.Player)
	
	If p\status=POWERPILL
		;time up! ghosts deadly again
		If MilliSecs() > powerTimer#
			p\status=OK
			ghostsEaten=0
			
			For g.Ghost=Each Ghost
				If (g\status And EDIBLE)
					g\status=OK
					g\image=g\normal
					g\running=False
					g\speed#=levelSpeed#
				EndIf
			Next

		;flash ghosts to warn of impending doom
		Else
		;that sound bug again!
		If (ediblePlayingFlag = 0)
			StopChannel(ediblePlaying)
			ediblePlayingFlag = 1
		EndIf
		If (Not ChannelPlaying(ediblePlaying)) And soundFlag
			ediblePlaying=PlaySound(edibleWav)
		EndIf
		;Print "hi!"
		If MilliSecs() > (powerTimer# - 250)
			For g.Ghost=Each Ghost
				If (g\status And EDIBLE)
					g\image=edibleImage1
				EndIf
			Next
		ElseIf MilliSecs() > (powerTimer# - 500)
			For g.Ghost=Each Ghost
				If g\status And EDIBLE
					g\image=edibleImage2
				EndIf
			Next
		ElseIf MilliSecs() > (powerTimer# - 750)
			For g.Ghost=Each Ghost
				If g\status And EDIBLE
					g\image=edibleImage1
				EndIf
			Next
		ElseIf MilliSecs() > (powerTimer# - 1000)
			For g.Ghost=Each Ghost
				If g\status And EDIBLE
					g\image=edibleImage2
				EndIf
			Next
		ElseIf MilliSecs() > (powerTimer# - 1250)
			For g.Ghost=Each Ghost
				If g\status And EDIBLE
					g\image=edibleImage1
				EndIf
			Next
		ElseIf MilliSecs() > (powerTimer# - 1500)
			For g.Ghost=Each Ghost
				If g\status And EDIBLE
					g\image=edibleImage2
				EndIf
			Next
		ElseIf MilliSecs() > (powerTimer# - 1750)
			For g.Ghost=Each Ghost
				If g\status And EDIBLE
					g\image=edibleImage1
				EndIf
			Next
		ElseIf MilliSecs() > (powerTimer# - 2000)
			For g.Ghost=Each Ghost
				If g\status And EDIBLE
					g\image=edibleImage2
				EndIf
			Next
		ElseIf MilliSecs() > (powerTimer# - 2250)
			For g.Ghost=Each Ghost
				If g\status And EDIBLE
					g\image=edibleImage1
				EndIf
			Next
		ElseIf MilliSecs() > (powerTimer# - 2500)
			For g.Ghost=Each Ghost
				If g\status And EDIBLE
					g\image=edibleImage2
				EndIf
			Next
		EndIf
		EndIf
	EndIf	
	
	;flash pill
	If MilliSecs() > pillFlashTimer# + 150
		For ppill.Power=Each Power
			If (ppill\status=OK And ppill\player=currentPlayer)
				ppill\state=ppill\state Xor 1
				ppill\image=pillimage(ppill\state)
				DrawImage ppill\image,ppill\x,ppill\y
			EndIf
		Next
		
		pillFlashTimer# = MilliSecs()		
	EndIf	
		
End Function


;pop points scored up
Function ShowPoints()

	For pts.Points=Each Points

	If MilliSecs() < pointsTimer# + 1000
		If pts\blank<>pointblank
			GrabImage pointblank,pts\x,pts\y
			pts\blank=pointblank
		EndIf
		DrawImage pts\image,pts\x,pts\y
	Else
		DrawImage pts\blank,pts\x,pts\y
		Delete pts
		pointsUp=False
	EndIf
		
	Next
End Function


Function DisplayBonusFruit(p.Player)

	If showFruit And fruitTimer#=0
		SetFruitStatus(p\level)
	ElseIf showFruit
		If MilliSecs() < fruitTimer#
			If fruitEaten
				p\score=p\score+fruitValue
				showFruit=False
				DrawImage fruitBlank,314,199
				fruitTimer#=0
				fruitEaten=False
				If soundFlag fruitPlaying=PlaySound(fruitWav)
			Else
				DrawImage fruit,314,199
			EndIf
		Else
			showFruit=False
			DrawImage fruitBlank,314,199
			fruitTimer#=0
			fruitEaten=False
		EndIf
	EndIf

End Function


Function SetFruitStatus(level)

		Select level
	
		Case 1 ;cherry
			fruit=fruitImage(0)
			fruitValue=100
			fruitTimer#=MilliSecs() + 10000
	
		Case 2 ;strawberry
			fruit=fruitImage(1)
			fruitValue=300
			fruitTimer#=MilliSecs() + 9500
	
		Case 3,4 ;peach
			fruit=fruitImage(2)
			fruitValue=500
			fruitTimer#=MilliSecs() + 9000
	
		Case 5,6 ;apple
			fruit=fruitImage(3)
			fruitValue=700
			fruitTimer#=MilliSecs() + 8500
	
		Case 7,8 ;grapes
			fruit=fruitImage(4)
			fruitValue=1000
			fruitTimer#=MilliSecs() + 8000
	
		Case 9,10 ;galaxian
			fruit=fruitImage(5)
			fruitValue=2000
			fruitTimer#=MilliSecs() + 7500
	
		Case 11,12 ;bell
			fruit=fruitImage(6)
			fruitValue=3000
			fruitTimer#=MilliSecs() + 7000
	
		Case 13,14 ;key
			fruit=fruitImage(7)
			fruitValue=5000
			fruitTimer#=MilliSecs() + 6500
	
		End Select
		
		Return fruit

End Function



;show player score
Function DisplayScore(score)

	If currentPlayer=PLAYERONE
		;update player 1 score
		scorePosX=255
		scorePosY=52
	Else
		scorePosX=405
		scorePosY=52
	EndIf
	
	tenthous=Int(score / 10000)
	thousands=Int((score - (tenthous * 10000)) / 1000)
	hundreds=Int((score - (tenthous * 10000) - (thousands * 1000)) / 100)
	tens=Int((score - (tenthous * 10000) - (thousands * 1000) - (hundreds * 100)) / 10)
	
	Color 8,4,6
	Rect scorePosX-45,scorePosY,60,8
	DrawImage digitImage,scorePosX,scorePosY,0
	DrawImage digitImage,scorePosX-8,scorePosY,tens
	
	If score => 100
		DrawImage digitImage,scorePosX-16,scorePosY,hundreds
	EndIf
	
	If score => 1000
		DrawImage digitImage,scorePosX-24,scorePosY,thousands
	EndIf

	If score => 10000
		DrawImage digitImage,scorePosX-32,scorePosY,tenthous
	EndIf

	If score > highScore
		highScore=score
	EndIf
	
	;update high score
	highPosX=337
	highPosY=52
	
	tenthous=Int(highScore / 10000)
	thousands=Int((highScore - (tenthous * 10000)) / 1000)
	hundreds=Int((highScore - (tenthous * 10000) - (thousands * 1000)) / 100)
	tens=Int((highScore - (tenthous * 10000) - (thousands * 1000) - (hundreds * 100)) / 10)
	
	Color 8,4,6
	Rect 295,52,60,8
	DrawImage digitImage,highPosX,highPosY,0
	DrawImage digitImage,highPosX-8,highPosY,tens
	
	If highScore => 100
		DrawImage digitImage,highPosX-16,highPosY,hundreds
	EndIf
	
	If highScore => 1000
		DrawImage digitImage,highPosX-24,highPosY,thousands
	EndIf

	If highScore => 10000
		DrawImage digitImage,highPosX-32,highPosY,tenthous
	EndIf


	;flash 1up/ 2up
	If currentPlayer=PLAYERONE
		upImage=oneUpImage
		plx=232
		ply=42
		
		DrawImage twoUpImage,382,42
	Else
		upImage=twoUpImage
		plx=382
		ply=42
		
		DrawImage oneupImage,232,42
	EndIf
	
	If (MilliSecs() > flashTimer# + 300)
		If (gameState And INTRO)
			DrawImage upImage,plx,ply			
		Else
			If flashState
				Color 8,4,6
				Rect plx,ply,30,10,True
			Else
				DrawImage upImage,plx,ply
			EndIf
		EndIf
		
		flashState = flashState Xor 1
		flashTimer#=MilliSecs()
	EndIf
		
End Function


;death animation
Function PlayDead(p.Player)

	Wait(1.5)
		
	ClearSprites()
	
	If showFruit
		DrawImage fruitBlank,314,199
	EndIf
	
	GrabImage p\mazeImage,209,67

	If soundFlag deathPlaying=PlaySound(deathWav)
	
	For frame=7 To 14
		DrawImage p\blank,p\x,p\y
		DrawImage p\image,p\x,p\y,frame
		FlipCanvas canvas

		Wait(.25)
		
		If KeyDown(1) gameState=QUIT
	Next
	
	DrawImage p\blank,p\x,p\y
	FlipCanvas canvas
	
	Wait(1)
	
	;remove a life
	p\lives=p\lives-1
	
	;game over?
	If gameMode=PLAYERTWO
		pp.Player=First Player
		pp=After pp
		chk1=pp\lives
		pp=After pp
		chk2=pp\lives
	
		If (chk1=0 And chk2=0)
			gameState=GAMEOVER
		ElseIf (currentPlayer=PLAYERONE And chk1=0)
			DrawImage p1Image,282,156,0
			DrawImage gameOverImage,282,204
			FlipCanvas canvas
			Wait(3)
			
			currentPlayer=PLAYERTWO
		ElseIf (currentPlayer=PLAYERTWO And chk2=0)
			DrawImage p2Image,282,156,0
			DrawImage gameOverImage,282,204
			FlipCanvas canvas
			Wait(3)
			
			currentPlayer=PLAYERONE
		ElseIf (currentplayer=PLAYERTWO And chk1>0) Or currentPlayer=PLAYERONE
			currentPlayer=Not currentPlayer
		EndIf
	ElseIf p\lives=0
		gameState=GAMEOVER
	EndIf
	
End Function


Function Wait(secs#)

	FlushKeys()
	startTimer#=MilliSecs()
	While (MilliSecs() < startTimer# + (secs#*1000))
		If KeyDown(1) Or KeyDown(57)
			startTimer#=0
			gameState=gameState Xor INTRO
			Exit
		EndIf
	Wend

End Function


;intermission
Function PlayIntermission()

	Color 8,4,6
	Rect 208,40,226,280,True
	
	p.Player=First Player
	p=After p
	
	If currentPlayer=PLAYERTWO
		p=After p
	EndIf
	
	p\x=480:p\y=216:p\frame=5:p\dir=MOVELEFT
	p\speed#=1.4
	p\timer#=MilliSecs()
	
	;enable red ghost
	g.Ghost=First Ghost
	g\y=p\y
	g\x=p\x+30
	g\image=g\normal
	g\status=OK
	g\dir=MOVELEFT
	g\speed#=1.46
	
	;hide the other 3 ghosts
	For cnt=1 To 3
		g=After g
		
		g\status=g\status Or EDIBLE Or EATEN
	Next
	;Color 255,255,255:Rect p\x,p\y,16,16,False:Flip:Stop
	StoreBackgroundData()

	g.Ghost=First Ghost
	Wait(3)

	
	;move wobman across screen chased by red ghost
	While (p\x < 482)
		If Not ChannelPlaying(intermission)
			intermission=PlaySound(interWav)
		EndIf
		
		ClearSprites()
		
		p\frame=p\frame+p\animDir

		If p\x < 140
			p\dir=MOVERIGHT
			p\frame=1
			p\y=198
			p\image=wobimage
			p\blank=wobblank
			p\x=145
			
			g\status=EDIBLE
			g\image=edibleImage1
			g\x=190
			g\speed#=1.1
				
			Wait(1)
		EndIf
				
		If p\dir=MOVELEFT
			p\x=p\x-p\speed#

			If p\frame=4
				p\frame=0
			ElseIf p\frame=-1
				p\frame=5
				p\animDir=-p\animDir
			ElseIf p\frame=6
				p\animDir=-p\animDir
			EndIf

			g\x=g\x-g\speed#
			g\frame=Not g\frame		
		ElseIf p\dir=MOVERIGHT
			If g\x > 240
				p\x=p\x+p\speed#
			EndIf
			
			If p\frame=2 Or p\frame=0
				p\animDir=-p\animDir	
			EndIf
				
			g\x=g\x+g\speed#
			g\frame=Not g\frame
			g\dir=MOVERIGHT
		EndIf
		
		StoreBackgroundData()
		DrawSprites()
		
		;hide things moving onto screen
		DrawPassages()
		
		Color 255,255,255
		Rect 207,36,228,302,False
		
		FlipCanvas canvas
	Wend
	
	Wait(3.5)
	
	p\image=pacimage
	p\blank=blank

End Function



;run game intro sequence
Function RunIntro()

	soundFlag=False
	p.Player=First Player
	
	p=After p
	lastP1Score=p\score
	p=After p
	lastP2Score=p\score
	
	p=First Player
	
	Color 8,4,6
	Rect 208,50,227,268,True
	Color 255,255,255
	Rect 207,36,228,302,False
		
	;display last score/high score
	DrawImage scoresImage,282,42
	DrawImage oneUpImage,232,42
	DrawImage twoUpImage,382,42
	
	currentPlayer=PLAYERONE
	DisplayScore(lastP1Score)
	currentPlayer=PLAYERTWO
	DisplayScore(lastP2Score)
		
	;show character/nickname
	DrawImage charTitleImage,264,90
	FlipCanvas canvas
	Wait(1)
		
	offset=0
	For g.Ghost=Each Ghost
		;draw ghost
		DrawImage g\image,239,110+offset,1
		DrawImage eyesRight,239,112+offset
		
		FlipCanvas canvas:Wait(1)
		
		If KeyDown(1)
			gameState=QUIT
		ElseIf KeyDown(57)
			gameState=CHOOSEPLAYERS
		EndIf
			
		If gameState=QUIT Or gameState=CHOOSEPLAYERS Exit
		
		;display name
		DrawImage g\char,266,112+offset
		
		FlipCanvas canvas:Wait(0.5)
		
		If KeyDown(1)
			gameState=QUIT
		ElseIf KeyDown(57)
			gameState=CHOOSEPLAYERS
		EndIf
			
		If gameState=QUIT Or gameState=CHOOSEPLAYERS Exit
		
		;display nickname
		DrawImage g\nick,354,112+offset
			
		FlipCanvas canvas:Wait(0.5)
		
		If KeyDown(1)
			gameState=QUIT
		ElseIf KeyDown(57)
			gameState=CHOOSEPLAYERS
		EndIf
			
		If gameState=QUIT Or gameState=CHOOSEPLAYERS Exit

		offset=offset+25
	Next
	
	;leave intro sequence?
	If Not (gameState And INTRO)
		Goto skip
	EndIf
	
	Wait(0.5)
	
	;leave intro sequence?
	If Not (gameState And INTRO)
		Goto skip
	EndIf
	
	;display points for pills
	DrawImage pillPoints,288,240
	FlipCanvas canvas
	
	Wait(1)

	;leave intro sequence?
	If Not (gameState And INTRO)
		Goto skip
	EndIf
	
	currentPlayer=COMPUTER
	
	;create intro power pills
	ppill.Power=New Power
	ppill\image=pillimage(0)
	ppill\state=1
	ppill\status=OK
	ppill\player=COMPUTER
		
	ppill\x=238
	ppill\y=220

	DrawImage ppill\image,ppill\x,ppill\y

	ppill.Power=New Power
	ppill\image=pillimage(0)
	ppill\state=1
	ppill\status=OK
	ppill\player=COMPUTER
		
	ppill\x=288
	ppill\y=257

	;display pills and collywobbles logo
	DrawImage ppill\image,ppill\x,ppill\y
	DrawImage collywobbles,218,300
	
	FlipCanvas canvas:Wait(1)
	
	p\x=424:p\y=216
	p\frame=5
	p\dir=MOVELEFT
	p\speed#=1.6
	
	For g.Ghost=Each Ghost
		g\timer#=MilliSecs()
		g\x=p\x+25+(16*(g\id-1))
		g\y=p\y
		g\speed#=1.7
	Next
	
	StoreBackgroundData()
	ghostsEaten=0
	gameTimer# = MilliSecs() + GAMESPEED
	
	;wait for keypress
	While (Not KeyDown(1)) And (Not KeyDown(57))
		Events()
		ClearSprites()
        gameDelay# = MilliSecs()

		If Not pointsUp
			;move wobman onto screen chased by ghosts
			If (gameDelay# > gameTimer#)
		    	gameTimer# = MilliSecs() + GAMESPEED
				p\frame=p\frame+p\animDir

				If p\dir=MOVELEFT
					p\x=p\x-p\speed#
					If p\x<238
						;p\x=246
						p\dir=MOVERIGHT
						p\frame=1
						p\status=POWERPILL
						powerTimer#=MilliSecs() + 10000
						
						ppill=First Power
						ppill\status=EATEN
						ppill\state=1
						DrawImage pillimage(1),ppill\x,ppill\y,0
							
						For g.ghost=Each Ghost
							g\status=EDIBLE
							g\image=edibleImage1
							g\speed#=0.8
						Next
					ElseIf p\frame=4
						p\frame=0
					ElseIf p\frame=-1
						p\frame=5
						p\animDir=-p\animDir
					ElseIf p\frame=6
						p\animDir=-p\animDir
					EndIf
				ElseIf p\dir=MOVERIGHT
					p\x=p\x+p\speed#
					If p\frame=2 Or p\frame=0
						p\animDir=-p\animDir	
					EndIf
				EndIf
			
				For g.ghost=Each Ghost
					g\frame = Not g\frame
					;g\timer#=MilliSecs()
					g\dir=p\dir
	
					If g\dir=MOVELEFT
						g\x=g\x-g\speed#
					Else
						g\x=g\x+g\speed#
					EndIf
			
					g\y=p\y
				Next
			EndIf
		Else
			ShowPoints()
		EndIf
		
		;flash pills
		ProcessPowerPills(p)
		
		;perform sprite functions
		StoreBackgroundData()
		DrawSprites()
		
		;hide things moving onto screen
		DrawPassages()
		Color 255,255,255
		Rect 207,36,228,302,False
		
		CheckCollisions(p)
		
		If (ghostsEaten=4) And (Not pointsUp)
			ghostsEaten=0
			
			For g.Ghost=Each Ghost
				g\image=g\normal
				g\status=g\status Xor EATEN
				pointsUp=False
			Next
			Exit
		EndIf
				
		FlipCanvas canvas
	Wend	


.skip	
	If (gameState And INTRO)
		gameMode=PLAYERONE
		currentPlayer=PLAYERONE
		gameState=(START Or INTRO)
		autoDir=0
	EndIf
	
	;delete intro power pills
	For ppill.Power=Each Power
		Delete ppill
	Next
					
End Function


Function Events()

	; -------------------------------------------------------------------------
	; Event processing loop (repeats until 'fps' timer event occurs)...
	; -------------------------------------------------------------------------
	
	Repeat
	
		e = WaitEvent (1) ; The 'wait' value comes from above section...

		; ---------------------------------------------------------------------
		; Got events, so process them...
		; ---------------------------------------------------------------------
		
		Select e

			; Close gadget hit...		
			Case EVENT_Close
				Exit
			
			; Menu item selected...
			Case EVENT_Menu
			
				; -------------------------------------------------------------
				; After an EVENT_Menu event, you get the menu item number from
				; EventData ()...
				; -------------------------------------------------------------
				
				item = EventData ()
				
				;Print "Selecting menu item"
				
				Select item
					Case 1
						Notify "Pac-Man clone created using BlitzPlus (c) Collywobbles Software 2002-2016"
					Case 3
						If Confirm ("Are you sure you want to quit?")					
							Exit
						EndIf
				End Select
				
		End Select
		
	Until e = EVENT_Timer

End Function


;***********
;move ghosts
;***********


;check if player is at junction (auto move only)
;check if pill has been eaten
;check if ghost is at a junction

;****************************************************************
;			data division (oops, this isn't Cobol is it?)
;****************************************************************

;pill data
Data 0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0
Data 0,2,0,0,0,0,2,0,0,0,0,0,2,0,0,2,0,0,0,0,0,2,0,0,0,0,2,0
Data 0,4,0,0,0,0,2,0,0,0,0,0,2,0,0,2,0,0,0,0,0,2,0,0,0,0,4,0
Data 0,2,0,0,0,0,2,0,0,0,0,0,2,0,0,2,0,0,0,0,0,2,0,0,0,0,2,0
Data 0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0
Data 0,2,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,2,0
Data 0,2,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,2,0
Data 0,2,2,2,2,2,2,0,0,2,2,2,2,0,0,2,2,2,2,0,0,2,2,2,2,2,2,0
Data 0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0
Data 0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0
Data 0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0
Data 0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0
Data 0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0
Data 0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0
Data 0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0
Data 0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0
Data 0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0
Data 0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0
Data 0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0
Data 0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0
Data 0,2,0,0,0,0,2,0,0,0,0,0,2,0,0,2,0,0,0,0,0,2,0,0,0,0,2,0
Data 0,2,0,0,0,0,2,0,0,0,0,0,2,0,0,2,0,0,0,0,0,2,0,0,0,0,2,0
Data 0,4,2,2,0,0,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,0,0,2,2,4,0
Data 0,0,0,2,0,0,2,0,0,2,0,0,0,0,0,0,0,0,2,0,0,2,0,0,2,0,0,0
Data 0,0,0,2,0,0,2,0,0,2,0,0,0,0,0,0,0,0,2,0,0,2,0,0,2,0,0,0
Data 0,2,2,2,2,2,2,0,0,2,2,2,2,0,0,2,2,2,2,0,0,2,2,2,2,2,2,0
Data 0,2,0,0,0,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,2,0
Data 0,2,0,0,0,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,2,0
Data 0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


;junctions - x,y,validDirs
;validDirs: 1=north;2=south;4=east;8=west;16=entrance
Data 214,72,6,254,72,14,302,72,10,326,72,6,374,72,14,414,72,10
Data 214,104,7,254,104,15,278,104,14,302,104,13,326,104,13,350,104,14,374,104,15,414,104,11
Data 214,128,5,254,128,11,278,128,5,302,128,10,326,128,6,350,128,9,374,128,7,414,128,9
Data 278,152,6,302,152,13,326,152,13,350,152,10
Data 254,176,15,278,176,11,350,176,7,374,176,15
Data 278,200,7,350,200,11
Data 214,224,6,254,224,15,278,224,13,302,224,10,326,224,6,350,224,13,374,224,15,414,224,10
Data 214,248,5,230,248,10,254,248,7,278,248,14,302,248,13,326,248,13,350,248,14,374,248,11,398,248,6,414,248,9
Data 214,272,6,230,272,13,254,272,9,278,272,5,302,272,10,326,272,6,350,272,9,374,272,5,398,272,13,414,272,10
Data 214,296,5,302,296,13,326,296,13,414,296,9

;hut junctions
Data 314,152,28
Data 298,170,2,298,176,7,298,182,1
Data 314,176,1
Data 330,170,2,330,176,11,330,182,1

;auto move sequence
Data MOVELEFT,MOVELEFT,MOVEUP,MOVELEFT,MOVEDOWN,MOVERIGHT,MOVEDOWN,MOVERIGHT
Data MOVEUP,MOVEUP,MOVERIGHT,MOVERIGHT,MOVEDOWN,MOVERIGHT,MOVEUP,MOVERIGHT
Data MOVERIGHT,MOVERIGHT,MOVELEFT,MOVEUP,MOVERIGHT,MOVEUP,MOVEUP,MOVERIGHT
Data MOVEDOWN,MOVERIGHT,MOVEDOWN,MOVERIGHT,MOVERIGHT,MOVEDOWN,MOVEDOWN,MOVEDOWN
Data MOVERIGHT,MOVEUP,MOVEUP,MOVEUP,MOVEUP,MOVELEFT,MOVEDOWN,MOVERIGHT